/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.entity;

import baguchan.hunterillager.HunterSounds;
import baguchan.hunterillager.entity.ai.BoomeranAttackGoal;
import baguchan.hunterillager.entity.projectile.BoomerangEntity;
import baguchan.hunterillager.init.HunterItems;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BannerItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HunterIllagerEntity
extends AbstractIllagerEntity
implements IRangedAttackMob {
    public static final Predicate<LivingEntity> TARGET_FOOD_SELECTOR = p_213616_0_ -> !p_213616_0_.func_70631_g_() && p_213616_0_.func_200600_R() != EntityType.field_220360_g && p_213616_0_.func_200600_R() != EntityType.field_200783_W && p_213616_0_.func_200600_R() != EntityType.field_200724_aC && p_213616_0_.func_200600_R() != EntityType.field_220353_aa;
    private static final Predicate<? super ItemEntity> ALLOWED_ITEMS = p_213616_0_ -> p_213616_0_.func_92059_d().func_77973_b().func_219967_s() != null && p_213616_0_.func_92059_d().func_77973_b().func_219967_s().func_221467_c();
    private final Inventory inventory = new Inventory(5);
    @Nullable
    private BlockPos homeTarget;
    private int cooldown;

    public HunterIllagerEntity(EntityType<? extends HunterIllagerEntity> p_i48556_1_, World p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new AbstractIllagerEntity.RaidOpenDoorGoal((AbstractIllagerEntity)this, (AbstractRaiderEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AbstractRaiderEntity.FindTargetGoal((AbstractRaiderEntity)this, (AbstractIllagerEntity)this, 10.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new RangedBowAttackGoal((MonsterEntity)this, 1.0, 50, 16.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new BoomeranAttackGoal(this, 50, 16.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.95f, true){

            public boolean func_75250_a() {
                return !(this.field_75441_b.func_184614_ca().func_77973_b() instanceof BowItem) && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !(this.field_75441_b.func_184614_ca().func_77973_b() instanceof BowItem) && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveToGoal(this, 26.0, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new GetFoodGoal(this, this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 10, true, false, TARGET_FOOD_SELECTOR){

            public boolean func_75250_a() {
                return HunterIllagerEntity.this.cooldown <= 0 && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    protected void func_71036_o() {
        ItemStack copy;
        Hand hand = this.func_184600_cs();
        if (this.field_184627_bm.equals(this.func_184586_b(hand)) && !this.field_184627_bm.func_190926_b() && this.func_184587_cr() && (copy = this.field_184627_bm.func_77946_l()).func_77973_b().func_219967_s() != null) {
            this.func_70691_i(copy.func_77973_b().func_219967_s().func_221466_a());
        }
        super.func_71036_o();
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_184587_cr() && this.func_184586_b(Hand.OFF_HAND).func_190926_b()) {
            ItemStack food = ItemStack.field_190927_a;
            if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70146_Z.nextFloat() < 0.0025f) {
                food = this.findFood();
            }
            if (!food.func_190926_b()) {
                this.func_184201_a(EquipmentSlotType.OFFHAND, food);
                this.func_184598_c(Hand.OFF_HAND);
            }
        }
        super.func_70636_d();
    }

    private ItemStack findFood() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b() || itemstack.func_77973_b().func_219967_s() == null || !itemstack.func_77973_b().func_219967_s().func_221467_c()) continue;
            return itemstack.func_77979_a(1);
        }
        return ItemStack.field_190927_a;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233818_a_, 26.0).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        if (this.homeTarget != null) {
            p_213281_1_.func_218657_a("HomeTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.homeTarget));
        }
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            listnbt.add((Object)itemstack.func_77955_b(new CompoundNBT()));
        }
        p_213281_1_.func_218657_a("Inventory", (INBT)listnbt);
        p_213281_1_.func_74768_a("HuntingCooldown", this.cooldown);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_74764_b("HomeTarget")) {
            this.homeTarget = NBTUtil.func_186861_c((CompoundNBT)p_70037_1_.func_74775_l("HomeTarget"));
        }
        ListNBT listnbt = p_70037_1_.func_150295_c("Inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.inventory.func_174894_a(itemstack);
        }
        this.cooldown = p_70037_1_.func_74762_e("HuntingCooldown");
        this.func_98053_h(true);
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
        boolean flag;
        ItemStack offHandStack = new ItemStack((IItemProvider)HunterItems.BOOMERANG);
        Raid raid = this.func_213663_ek();
        int i = 1;
        if (p_213660_1_ > raid.func_221306_a(Difficulty.NORMAL)) {
            i = 2;
        }
        ItemStack itemstack = raid.func_221291_n() < 2 || p_213660_1_ <= raid.func_221306_a(Difficulty.NORMAL) ? (this.field_70146_Z.nextBoolean() ? new ItemStack((IItemProvider)Items.field_151031_f) : new ItemStack((IItemProvider)Items.field_151052_q)) : (this.field_70146_Z.nextBoolean() ? new ItemStack((IItemProvider)Items.field_151031_f) : new ItemStack((IItemProvider)Items.field_151040_l));
        this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151147_al, 6));
        boolean bl = flag = this.field_70146_Z.nextFloat() <= raid.func_221308_w();
        if (flag) {
            HashMap map;
            if (itemstack.func_77973_b() == Items.field_151031_f) {
                map = Maps.newHashMap();
                map.put(Enchantments.field_185309_u, i);
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemstack);
            } else {
                map = Maps.newHashMap();
                map.put(Enchantments.field_185302_k, i);
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemstack);
            }
            this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151083_be, 2));
            HashMap map2 = Maps.newHashMap();
            map2.put(Enchantments.field_185302_k, i);
            EnchantmentHelper.func_82782_a((Map)map2, (ItemStack)offHandStack);
        }
        if (this.field_70146_Z.nextFloat() < 0.25f) {
            HashMap map3 = Maps.newHashMap();
            map3.put(Enchantments.field_203193_C, i);
            EnchantmentHelper.func_82782_a((Map)map3, (ItemStack)offHandStack);
            this.func_184611_a(Hand.OFF_HAND, offHandStack);
        }
        this.func_184611_a(Hand.MAIN_HAND, itemstack);
    }

    protected void func_175445_a(ItemEntity p_175445_1_) {
        ItemStack itemstack = p_175445_1_.func_92059_d();
        if (itemstack.func_77973_b() instanceof BannerItem) {
            super.func_175445_a(p_175445_1_);
        } else {
            Item item = itemstack.func_77973_b();
            if (this.wantsFood(itemstack)) {
                this.func_233630_a_(p_175445_1_);
                this.func_71001_a((Entity)p_175445_1_, itemstack.func_190916_E());
                ItemStack itemstack1 = this.inventory.func_174894_a(itemstack);
                if (itemstack1.func_190926_b()) {
                    p_175445_1_.func_70106_y();
                } else {
                    itemstack.func_190920_e(itemstack1.func_190916_E());
                }
            } else if (item == HunterItems.BOOMERANG && this.func_184592_cb().func_190926_b()) {
                this.func_233630_a_(p_175445_1_);
                this.func_71001_a((Entity)p_175445_1_, itemstack.func_190916_E());
                this.func_184611_a(Hand.OFF_HAND, itemstack);
            }
        }
    }

    public boolean func_174820_d(int p_174820_1_, ItemStack p_174820_2_) {
        if (super.func_174820_d(p_174820_1_, p_174820_2_)) {
            return true;
        }
        int i = p_174820_1_ - 300;
        if (i >= 0 && i < this.inventory.func_70302_i_()) {
            this.inventory.func_70299_a(i, p_174820_2_);
            return true;
        }
        return false;
    }

    private boolean wantsFood(ItemStack p_213672_1_) {
        return p_213672_1_.func_77973_b().func_219967_s() != null && p_213672_1_.func_77973_b().func_219967_s().func_221467_c();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        ILivingEntityData ilivingentitydata = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_180481_a(p_213386_2_);
        this.func_180483_b(p_213386_2_);
        return ilivingentitydata;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70301_a(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        if (this.func_213663_ek() == null) {
            this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151147_al, 4));
            if (this.field_70146_Z.nextFloat() < 0.5f) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151041_m));
                if (this.field_70146_Z.nextBoolean()) {
                    ItemStack offHandStack = new ItemStack((IItemProvider)HunterItems.BOOMERANG);
                    HashMap map3 = Maps.newHashMap();
                    map3.put(Enchantments.field_203193_C, 1);
                    EnchantmentHelper.func_82782_a((Map)map3, (ItemStack)offHandStack);
                    this.func_184611_a(Hand.OFF_HAND, offHandStack);
                }
            }
        }
    }

    public boolean func_184191_r(Entity p_184191_1_) {
        if (super.func_184191_r(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && p_184191_1_.func_96124_cp() == null;
        }
        return false;
    }

    public SoundEvent func_213654_dW() {
        return HunterSounds.HUNTER_ILLAGER_LAUGH;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191268_hm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191269_hn;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_191270_ho;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.func_213398_dR()) {
            return this.func_233631_a_(Items.field_151031_f) || this.func_233631_a_(HunterItems.BOOMERANG) ? AbstractIllagerEntity.ArmPose.BOW_AND_ARROW : AbstractIllagerEntity.ArmPose.ATTACKING;
        }
        return this.func_213656_en() ? AbstractIllagerEntity.ArmPose.CELEBRATING : AbstractIllagerEntity.ArmPose.CROSSED;
    }

    public void func_241847_a(ServerWorld p_241847_1_, LivingEntity p_241847_2_) {
        super.func_241847_a(p_241847_1_, p_241847_2_);
        this.func_184185_a(HunterSounds.HUNTER_ILLAGER_LAUGH, this.func_70599_aP(), this.func_70647_i());
        this.cooldown = 300;
    }

    public void setHomeTarget(@Nullable BlockPos p_213726_1_) {
        this.homeTarget = p_213726_1_;
    }

    @Nullable
    private BlockPos getHomeTarget() {
        return this.homeTarget;
    }

    public void func_82196_d(LivingEntity p_82196_1_, float p_82196_2_) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)p_82196_2_);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        double d0 = p_82196_1_.func_226277_ct_() - this.func_226277_ct_();
        double d1 = p_82196_1_.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
        double d2 = p_82196_1_.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    public void performBoomeranAttack(LivingEntity p_82196_1_, float p_82196_2_) {
        BoomerangEntity boomerang = new BoomerangEntity(this.field_70170_p, (LivingEntity)this, this.func_184592_cb());
        double d0 = p_82196_1_.func_226277_ct_() - this.func_226277_ct_();
        double d1 = p_82196_1_.func_226283_e_(0.3333333333333333) - boomerang.func_226278_cu_();
        double d2 = p_82196_1_.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        boomerang.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)boomerang);
        this.func_184592_cb().func_190918_g(1);
    }

    public static class GetFoodGoal<T extends HunterIllagerEntity>
    extends Goal {
        private final T mob;
        final /* synthetic */ HunterIllagerEntity this$0;

        public GetFoodGoal(T p_i50572_2_) {
            this.this$0 = this$0;
            this.mob = p_i50572_2_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!this.mob.func_213657_el()) {
                List list = ((HunterIllagerEntity)((Object)this.mob)).field_70170_p.func_175647_a(ItemEntity.class, this.mob.func_174813_aQ().func_72314_b(16.0, 8.0, 16.0), ALLOWED_ITEMS);
                if (!list.isEmpty()) {
                    return this.mob.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.15f);
                }
                return false;
            }
            return false;
        }

        public void func_75246_d() {
            List list;
            if (this.mob.func_70661_as().func_208485_j().func_218137_a((IPosition)this.mob.func_213303_ch(), 1.414) && !(list = ((HunterIllagerEntity)((Object)this.mob)).field_70170_p.func_175647_a(ItemEntity.class, this.mob.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0), ALLOWED_ITEMS)).isEmpty()) {
                ((HunterIllagerEntity)((Object)this.mob)).func_175445_a((ItemEntity)list.get(0));
            }
        }
    }

    class MoveToGoal
    extends Goal {
        final HunterIllagerEntity hunter;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(HunterIllagerEntity p_i50459_2_, double p_i50459_3_, double p_i50459_5_) {
            this.hunter = p_i50459_2_;
            this.stopDistance = p_i50459_3_;
            this.speedModifier = p_i50459_5_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            this.hunter.setHomeTarget(null);
            HunterIllagerEntity.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.hunter.getHomeTarget();
            double distance = this.hunter.field_70170_p.func_72935_r() ? this.stopDistance : this.stopDistance / 3.0;
            return blockpos != null && this.isTooFarAway(blockpos, distance);
        }

        public void func_75246_d() {
            BlockPos blockpos = this.hunter.getHomeTarget();
            if (blockpos != null && HunterIllagerEntity.this.field_70699_by.func_75500_f()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vector3d vector3d = new Vector3d((double)blockpos.func_177958_n() - this.hunter.func_226277_ct_(), (double)blockpos.func_177956_o() - this.hunter.func_226278_cu_(), (double)blockpos.func_177952_p() - this.hunter.func_226281_cx_()).func_72432_b();
                    Vector3d vector3d1 = vector3d.func_186678_a(10.0).func_72441_c(this.hunter.func_226277_ct_(), this.hunter.func_226278_cu_(), this.hunter.func_226281_cx_());
                    HunterIllagerEntity.this.field_70699_by.func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.speedModifier);
                } else {
                    HunterIllagerEntity.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.func_218137_a((IPosition)this.hunter.func_213303_ch(), p_220846_2_);
        }
    }
}

